/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import net.minecraft.class_1160;
import net.minecraft.class_1161;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class Vec3d
extends VecNd<Vec3d> {
    public double x;
    public double y;
    public double z;

    public Vec3d() {
    }

    public Vec3d(class_2382 vec) {
        this(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(Vec3d vec) {
        super(vec);
    }

    public Vec3d(class_1161 vec) {
        this(vec.field_5661, vec.field_5660, vec.field_5659);
    }

    public Vec3d(class_243 vec) {
        this(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public Vec3d(class_1160 step) {
        this(step.method_4943(), step.method_4945(), step.method_4947());
    }

    public class_243 toVanilla() {
        return new class_243(this.x, this.y, this.z);
    }

    public class_2338 toBlockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    @Override
    public void set(Vec3d vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    @Override
    public double get(int dim) {
        return switch (dim) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> 0.0;
        };
    }

    @Override
    public double get(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
        };
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(Axis axis, double value) {
        switch (axis) {
            case X: {
                this.x = value;
                break;
            }
            case Y: {
                this.y = value;
                break;
            }
            case Z: {
                this.z = value;
            }
        }
    }

    @Override
    public void set(int dim, double value) {
        switch (dim) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
            }
        }
    }

    @Override
    public int dimensions() {
        return 3;
    }

    @Override
    public Vec3d copy() {
        return new Vec3d(this.x, this.y, this.z);
    }

    @Override
    public void add(Vec3d vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    @Override
    public void sub(Vec3d vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    @Override
    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vec3d) {
            return ((Vec3d)obj).x == this.x && ((Vec3d)obj).y == this.y && ((Vec3d)obj).z == this.z;
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(Vec3d var1, double var2) {
        double var3 = this.x - var1.x;
        if (Double.isNaN(var3)) {
            return false;
        }
        double d = var3 < 0.0 ? -var3 : var3;
        if (d > var2) {
            return false;
        }
        var3 = this.y - var1.y;
        if (Double.isNaN(var3)) {
            return false;
        }
        double d2 = var3 < 0.0 ? -var3 : var3;
        if (d2 > var2) {
            return false;
        }
        var3 = this.z - var1.z;
        if (Double.isNaN(var3)) {
            return false;
        }
        return (var3 < 0.0 ? -var3 : var3) <= var2;
    }

    @Override
    public double distance(Vec3d vec) {
        double x = this.x - vec.x;
        double y = this.y - vec.y;
        double z = this.z - vec.z;
        return Math.sqrt(x * x + y * y + z * z);
    }

    @Override
    public double distanceSqr(Vec3d vec) {
        double x = this.x - vec.x;
        double y = this.y - vec.y;
        double z = this.z - vec.z;
        return x * x + y * y + z * z;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double angle(Vec3d vec) {
        double vDot = this.dot(vec) / (this.length() * vec.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    public void cross(Vec3d vec1, Vec3d vec2) {
        this.x = vec1.y * vec2.z - vec1.z * vec2.y;
        this.y = vec2.x * vec1.z - vec2.z * vec1.x;
        this.z = vec1.x * vec2.y - vec1.y * vec2.x;
    }

    @Override
    public double dot(Vec3d vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }
}

